<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsMalwareSeverityCount File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;
/**
* WindowsMalwareSeverityCount class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsMalwareSeverityCount extends Entity
{
    /**
    * Gets the distinctMalwareCount
    * Count of distinct malwares for this malware State. Valid values -2147483648 to 2147483647
    *
    * @return int|null The distinctMalwareCount
    */
    public function getDistinctMalwareCount()
    {
        if (array_key_exists("distinctMalwareCount", $this->_propDict)) {
            return $this->_propDict["distinctMalwareCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the distinctMalwareCount
    * Count of distinct malwares for this malware State. Valid values -2147483648 to 2147483647
    *
    * @param int $val The value of the distinctMalwareCount
    *
    * @return WindowsMalwareSeverityCount
    */
    public function setDistinctMalwareCount($val)
    {
        $this->_propDict["distinctMalwareCount"] = $val;
        return $this;
    }

    /**
    * Gets the lastUpdateDateTime
    * The Timestamp of the last update for the WindowsMalwareSeverityCount in UTC
    *
    * @return \DateTime|null The lastUpdateDateTime
    */
    public function getLastUpdateDateTime()
    {
        if (array_key_exists("lastUpdateDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastUpdateDateTime"], "\DateTime") || is_null($this->_propDict["lastUpdateDateTime"])) {
                return $this->_propDict["lastUpdateDateTime"];
            } else {
                $this->_propDict["lastUpdateDateTime"] = new \DateTime($this->_propDict["lastUpdateDateTime"]);
                return $this->_propDict["lastUpdateDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the lastUpdateDateTime
    * The Timestamp of the last update for the WindowsMalwareSeverityCount in UTC
    *
    * @param \DateTime $val The value to assign to the lastUpdateDateTime
    *
    * @return WindowsMalwareSeverityCount The WindowsMalwareSeverityCount
    */
    public function setLastUpdateDateTime($val)
    {
        $this->_propDict["lastUpdateDateTime"] = $val;
         return $this;
    }
    /**
    * Gets the malwareDetectionCount
    * Count of threats detections for this malware severity. Valid values -2147483648 to 2147483647
    *
    * @return int|null The malwareDetectionCount
    */
    public function getMalwareDetectionCount()
    {
        if (array_key_exists("malwareDetectionCount", $this->_propDict)) {
            return $this->_propDict["malwareDetectionCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the malwareDetectionCount
    * Count of threats detections for this malware severity. Valid values -2147483648 to 2147483647
    *
    * @param int $val The value of the malwareDetectionCount
    *
    * @return WindowsMalwareSeverityCount
    */
    public function setMalwareDetectionCount($val)
    {
        $this->_propDict["malwareDetectionCount"] = $val;
        return $this;
    }

    /**
    * Gets the severity
    * Malware Threat Severity. computed. Possible values are: unknown, low, moderate, high, severe. Possible values are: unknown, low, moderate, high, severe.
    *
    * @return WindowsMalwareSeverity|null The severity
    */
    public function getSeverity()
    {
        if (array_key_exists("severity", $this->_propDict)) {
            if (is_a($this->_propDict["severity"], "\Beta\Microsoft\Graph\Model\WindowsMalwareSeverity") || is_null($this->_propDict["severity"])) {
                return $this->_propDict["severity"];
            } else {
                $this->_propDict["severity"] = new WindowsMalwareSeverity($this->_propDict["severity"]);
                return $this->_propDict["severity"];
            }
        }
        return null;
    }

    /**
    * Sets the severity
    * Malware Threat Severity. computed. Possible values are: unknown, low, moderate, high, severe. Possible values are: unknown, low, moderate, high, severe.
    *
    * @param WindowsMalwareSeverity $val The value to assign to the severity
    *
    * @return WindowsMalwareSeverityCount The WindowsMalwareSeverityCount
    */
    public function setSeverity($val)
    {
        $this->_propDict["severity"] = $val;
         return $this;
    }
}
